// i18n.js

import {
    onDomReady
} from "./utils.js";

const translations = {
    en: {
        addUser: "Add user",
        username: "Username",
        userid: "User ID",
        img: "Img Source",
    },
    ru: {
        addUser: "Добавить пользователя",
        username: "Имя",
        userid: "ID польз."
    }
};

const defaultLang = 'en';
let currentLang = localStorage.getItem('lang') || defaultLang;

const attrMap = {
    'data-i18n': 'textContent',
    'data-i18n-placeholder': 'placeholder',
    'data-i18n-alt': 'alt',
    'data-i18n-title': 'title'
};

const datasetMap = {
    'data-i18n': 'i18n',
    'data-i18n-placeholder': 'i18nPlaceholder',
    'data-i18n-alt': 'i18nAlt',
    'data-i18n-title': 'i18nTitle'
};

export function setLanguage(lang) {
    if (translations[lang]) {
        currentLang = lang;
        localStorage.setItem('lang', lang);
        document.documentElement.lang = lang;
    }
}

export function tr(key, vars = {}) {
    let str = translations[currentLang][key] ?? translations[defaultLang][key] ?? key;
    for (const [k, v] of Object.entries(vars)) {
        str = str.replace(`{${k}}`, v);
    }
    return str;
}

function updateDocumentLanguage_() {
    const selector = Object.keys(attrMap).map(attr => `[${attr}]`).join(',');
    document.querySelectorAll(selector).forEach(updateElementLanguage);
    document.querySelectorAll('template').forEach(template => {
        template.content.querySelectorAll(selector).forEach(updateElementLanguage);
    });
}

export function updateElementLanguage(el) {
    for (const [attr, prop] of Object.entries(attrMap)) {
        const datasetKey = datasetMap[attr];
        const key = el.dataset[datasetKey];
        if (key) el[prop] = tr(key);
    }
}


export function updateDocumentLanguage() {
    onDomReady(() => {
        updateDocumentLanguage_();
    });
}