async function urlToBase64(url) {
  // Загружаем изображение как Blob
  const response = await fetch(url, { mode: 'cors' }); // CORS обязателен для других доменов
  if (!response.ok) throw new Error(`HTTP error! Status: ${response.status}`);

  const blob = await response.blob();

  // Конвертируем Blob в Base64 через FileReader
  return await new Promise((resolve, reject) => {
    const reader = new FileReader();
    reader.onloadend = () => resolve(reader.result); // результат будет "data:image/..."
    reader.onerror = reject;
    reader.readAsDataURL(blob);
  });
}

// Пример использования
(async () => {
  try {
    const base64 = await urlToBase64("https://cdn.discordapp.com/attachments/.../image.png");
    console.log(base64); // data:image/png;base64,...
    
    // Можно сразу вставить в CSS
    document.getElementById("myDiv").style.backgroundImage = `url(${base64})`;
  } catch (err) {
    console.error(err);
  }
})();
